<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Tiny latex plugin settings.
 *
 * @package    tiny_latex
 * @copyright  2022 Huong Nguyen <huongnv13@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

$ADMIN->add('editortiny', new admin_category('tiny_latex', new lang_string('pluginname', 'tiny_latex')));
$settings = new admin_settingpage('tiny_latex_settings', new lang_string('settings', 'tiny_latex'));

if ($ADMIN->fulltree) {
    // Group 1.
    $name = new lang_string('librarygroup1', 'tiny_latex');
    $desc = new lang_string('librarygroup1_desc', 'tiny_latex');
    $default = '
\frac{x}{y}
\sqrt{x}
\ {a}^n
\ {a}_m
\cdot
\pm
\approx
\pi
\angle
\alpha
\beta
\gamma
\ ^o{C}
\leftarrow
\rightarrow
\Rightarrow
\ a_nb_m
\ a_n(bc)_m
';
    $setting = new admin_setting_configtextarea('tiny_latex/librarygroup1',
        $name,
        $desc,
        $default);
    $settings->add($setting);
}
