define("tiny_latex/ui",["exports","tiny_latex/modal","core/modal_events","tiny_latex/options","core/event","tiny_latex/repository","core/notification","core/utils","tiny_latex/selectors","tiny_latex/latex"],(function(_exports,_modal,_modal_events,_options,_event,TinyLatexRepository,_notification,_utils,_selectors,_latex){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Tiny Latex UI.
   *
   * @module      tiny_latex/ui
   * @copyright   2022 Huong Nguyen <huongnv13@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */let currentForm;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.handleAction=void 0,_modal=_interopRequireDefault(_modal),_modal_events=_interopRequireDefault(_modal_events),TinyLatexRepository=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(TinyLatexRepository),_selectors=_interopRequireDefault(_selectors);let lastCursorPos=0;_exports.handleAction=editor=>{displayDialogue(editor)};const displayDialogue=async editor=>{let data={};const currentLatexData=(0,_latex.getCurrentLatexData)(editor);currentLatexData&&Object.assign(data,currentLatexData);const modal=await _modal.default.create({templateContext:getTemplateContext(editor,data)}),$root=await modal.getRoot(),root=$root[0];currentForm=root.querySelector(_selectors.default.elements.form);const contextId=(0,_options.getContextId)(editor),debouncedPreviewUpdater=(0,_utils.debounce)((()=>updatePreview((0,_options.getContextId)(editor))),500);$root.on(_modal_events.default.shown,(()=>{const library=root.querySelector(_selectors.default.elements.library);TinyLatexRepository.filterLatex(contextId,library.innerHTML).then((async data=>(library.innerHTML=data.content,updatePreview(contextId),notifyFilter(library),data))).catch(_notification.exception)})),root.addEventListener("click",(e=>{const libraryItem=e.target.closest(_selectors.default.elements.libraryItem),submitAction=e.target.closest(_selectors.default.actions.submit),textArea=e.target.closest(".tiny_latex_latex");libraryItem&&(e.preventDefault(),selectLibraryItem(libraryItem,contextId)),submitAction&&(e.preventDefault(),(0,_latex.setLatex)(currentForm,editor),modal.destroy()),textArea&&debouncedPreviewUpdater()})),root.addEventListener("keyup",(e=>{e.target.closest(_selectors.default.elements.latexTextArea)&&debouncedPreviewUpdater()})),root.addEventListener("keydown",(e=>{e.target.closest(_selectors.default.elements.libraryItem)&&(37!=e.keyCode&&39!=e.keyCode||groupNavigation(e))}))},getTemplateContext=(editor,data)=>{const libraries=(0,_options.getLibraries)(editor),texDocsUrl=(0,_options.getTexDocsUrl)(editor);return Object.assign({},{elementid:editor.id,elementidescaped:CSS.escape(editor.id),libraries:libraries,texdocsurl:texDocsUrl,delimiters:_selectors.default.delimiters},data)},selectLibraryItem=(libraryItem,contextId)=>{const tex=libraryItem.getAttribute("data-tex"),input=currentForm.querySelector(_selectors.default.elements.latexTextArea);let oldValue,newValue,focusPoint=0;oldValue=input.value,newValue=oldValue.substring(0,lastCursorPos)," "!==newValue.charAt(newValue.length-1)&&(newValue+=" "),newValue+=tex,focusPoint=newValue.length," "!==oldValue.charAt(lastCursorPos)&&(newValue+=" "),newValue+=oldValue.substring(lastCursorPos,oldValue.length),input.value=newValue,input.focus(),input.selectionStart=input.selectionEnd=focusPoint,updatePreview(contextId)},updatePreview=contextId=>{const textarea=currentForm.querySelector(_selectors.default.elements.latexTextArea),preview=currentForm.querySelector(_selectors.default.elements.preview),cursorLatex=_selectors.default.cursorLatex,isChar=/[a-zA-Z{]/;let currentPos=textarea.selectionStart,latex=textarea.value;for(currentPos||(currentPos=0),(0,_latex.getSourceLatex)()&&(currentPos=latex.length);"\\"===latex.charAt(currentPos)&&currentPos>=0;)currentPos-=1;if(0!==currentPos&&"{"!=latex.charAt(currentPos-1))for(;isChar.test(latex.charAt(currentPos))&&currentPos<latex.length&&isChar.test(latex.charAt(currentPos-1));)currentPos+=1;lastCursorPos=currentPos,latex=""+latex.substring(0,currentPos)+cursorLatex+latex.substring(currentPos),latex=_selectors.default.delimiters.start+" "+latex+" "+_selectors.default.delimiters.end,TinyLatexRepository.filterLatex(contextId,latex).then((data=>(preview.innerHTML=data.content,notifyFilter(preview),data))).catch(_notification.exception)},notifyFilter=element=>{(0,_event.notifyFilterContentUpdated)(element)},groupNavigation=e=>{e.preventDefault();const current=e.target.closest(_selectors.default.elements.libraryItem),parent=current.parentNode,buttons=Array.prototype.slice.call(parent.querySelectorAll(_selectors.default.elements.libraryItem)),direction=37!==e.keyCode?1:-1;let nextButton,index=buttons.indexOf(current);index<0&&(index=0),index+=direction,index<0?index=buttons.length-1:index>=buttons.length&&(index=0),nextButton=buttons[index],nextButton.focus()}}));

//# sourceMappingURL=ui.min.js.map