define("tiny_latex/latex",["exports","tiny_latex/selectors"],(function(_exports,_selectors){var obj;
/**
   * Latex helper for Tiny Latex plugin.
   *
   * @module      tiny_latex/latex
   * @copyright   2022 Huong Nguyen <huongnv13@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.setLatex=_exports.getSourceLatex=_exports.getSelectedLatex=_exports.getCurrentLatexData=void 0,_selectors=(obj=_selectors)&&obj.__esModule?obj:{default:obj};let sourceLatex=null;const getSourceLatex=()=>sourceLatex;_exports.getSourceLatex=getSourceLatex;const getSelectedLatex=editor=>{const currentSelection=editor.selection.getSel();if(!currentSelection)return!1;const textSelection=editor.selection.getNode().textContent,currentCaretPos=currentSelection.focusOffset;let returnValue=!1;return _selectors.default.latexPatterns.forEach((pattern=>{const regexPattern=new RegExp(pattern.source,"g");[...textSelection.matchAll(regexPattern)].forEach((matches=>{const match=matches[0];let startIndex=0;const startOuter=textSelection.indexOf(match,startIndex),endOuter=startOuter+match.length,innerMatch=match.match(pattern);if(innerMatch&&innerMatch.length){const startInner=textSelection.indexOf(innerMatch[1],startOuter),endInner=startInner+innerMatch[1].length;if(currentCaretPos>=startOuter&&currentCaretPos<=endOuter)return returnValue=innerMatch[1],void(sourceLatex={startInnerPosition:startInner,endInnerPosition:endInner,innerMatch:innerMatch})}startIndex=endOuter}))})),!1!==returnValue?returnValue=returnValue.trim():sourceLatex=null,returnValue};_exports.getSelectedLatex=getSelectedLatex;_exports.getCurrentLatexData=editor=>{let properties={};const latex=getSelectedLatex(editor);return latex&&(properties.latex=latex),properties};_exports.setLatex=(currentForm,editor)=>{const input=currentForm.querySelector(_selectors.default.elements.latexTextArea),sourceLatex=getSourceLatex();let value=input.value;if(""!==value)if(sourceLatex){const selectedNode=editor.selection.getNode(),text=selectedNode.textContent;value=" "+value+" ",selectedNode.textContent=text.slice(0,sourceLatex.startInnerPosition)+value+text.slice(sourceLatex.endInnerPosition)}else value=_selectors.default.delimiters.start+" "+value+" "+_selectors.default.delimiters.end,editor.insertContent(value)}}));

//# sourceMappingURL=latex.min.js.map